(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13405,        540]*)
(*NotebookOutlinePosition[     14307,        570]*)
(*  CellTagsIndexPosition[     14263,        566]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[
"Homogeneous Functions & Equations"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "The term ",
  StyleBox["Homogeneous",
    FontSlant->"Italic"],
  " has several different mathematical meanings. Even in the case of \
differential equations, two meanings prevail. One is similar to the meaning \
the term has in linear algebra, and, in fact is used that way only in linear \
contexts. The other, the one considered here, is usually applied in nonlinear \
settings, where the meaning is more nearly that of the standard \
non-mathematical one: ",
  StyleBox["uniform throughout",
    FontVariations->{"Underline"->True}],
  ". You may have to take special care with the manipulation of certain \
functions."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Definition: Homogeneous Function"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Given a function ",
  StyleBox["f[x, y]",
    FontWeight->"Bold"],
  " of two variables, we say that f is ",
  StyleBox["homogeneous of order n",
    FontVariations->{"Underline"->True}],
  " provided that ",
  StyleBox["f[t*x, t*y]=t^n*f[x, y]",
    FontWeight->"Bold"],
  " for all positive numbers t.   The order n may be any real number.\n\nMore \
generally, a function ",
  StyleBox["f[x", "Input"],
  StyleBox["1", "Input",
    FontSize->9],
  StyleBox[", x", "Input"],
  StyleBox["2", "Input",
    FontSize->9],
  StyleBox[", ... x", "Input"],
  StyleBox["m", "Input",
    FontSize->9],
  StyleBox["]", "Input"],
  " of m variables is homogeneous of order n provided that ",
  StyleBox["f[t*x1,t*x2,...,t*xm]==t^n*f[x1,x2,...xm]", "Input"],
  " for all positive numbers t."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples of Homogeneous Functions"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Example 1"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x_, y_] = x - 3\ \@\(x\ y\) + 5\ y\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x + 5\ y - 3\ \@\(x\ y\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[t\ x, t\ y]\)], "Input"],

Cell[BoxData[
    \(t\ x + 5\ t\ y - 3\ \@\(t\^2\ x\ y\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[PowerExpand[f[t\ x, t\ y]]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(t\ \((x - 3\ \@x\ \@y + 5\ y)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cancel[
      Factor[PowerExpand[f[t\ x, t\ y]]]\/PowerExpand[f[x, y]]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(t\)], "Output"]
}, Closed]],

Cell["\<\
The function is homogeneous of degree 1. 

Manipulation with the functions PowerExpand and Factor enabled us to get the \
variable t isolated. A manual step might have been reasonable here.\
\>", \
"Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example 2"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x_, y_] = \@\(x\^3 + y\^3\)\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\@\(x\^3 + y\^3\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[t\ x, t\ y]\)], "Input"],

Cell[BoxData[
    \(\@\(t\^3\ x\^3 + t\^3\ y\^3\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[f[t\ x, t\ y]]\)], "Input"],

Cell[BoxData[
    \(\@\(t\^3\ \((x\^3 + y\^3)\)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerExpand[Simplify[f[t\ x, t\ y]]]\)], "Input"],

Cell[BoxData[
    \(t\^\(3/2\)\ \@\(x\^3 + y\^3\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cancel[PowerExpand[Simplify[f[t\ x, t\ y]]]\/f[x, y]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(t\^\(3/2\)\)], "Output"]
}, Closed]],

Cell["\<\
Again we faced a manipulative excursion.  We can manually transform \
the numerator as follows to get the desired result (in a slightly different \
form):\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cancel[
        f[t\ x, t\ y]\/f[x, y]] /. \@\(p1_\ q1_ + p1_\ q2_\) \[Rule] \@p1\ \@\
\(q1 + q2\)\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\@t\^3\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example 3"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"One might think that this function is homogeneous of degree 2, but it is \
not, as this calculation shows:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x_, y_] = x\^2 + y\^2 + 1\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1 + x\^2 + y\^2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[f[t\ x, t\ y] - t\^2\ f[x, y]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1 - t\^2\)], "Output"]
}, Closed]],

Cell["\<\
Had the function been homogeneous of degree 2, then this would have \
been 0. Since it is not zero, the function is not homogeneous of degree 2. \
Note that this calculation does not say that the function is not homogeneous \
-- merely that it is not homogeneous of degree 2. But 2 is the only possible \
order for the function to be, so, in fact, it is not homogeneous.\
\>", "Text",\

  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example 4"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x_, y_] = x\/\(2\ y\) + 4\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(4 + x\/\(2\ y\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cancel[f[t\ x, t\ y]\/f[x, y]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1\)], "Output"]
}, Closed]],

Cell[TextData[
"Since 1==t^0, this function is homogeneous of degree 0."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Homogeneous (nonlinear) Differential Equations"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Definition"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "A differential equation of the form:\n\t\t",
  StyleBox["p[x, y]*dx + q[x, y]*dy ==0",
    FontWeight->"Bold"],
  "\nis called ",
  StyleBox["homogeneous",
    FontVariations->{"Underline"->True}],
  " provided that both p[x, y] and q[x, y] are homogeneous functions ",
  StyleBox["of the same order",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Theory of solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "If the differential equation  ",
  StyleBox["p[x, y]*dx + q[x, y]*dy ==0 ",
    FontWeight->"Bold"],
  "is homogeneous of order n, then the equation can be converted into an \
equation in which the variables are separable by the substitution: ",
  StyleBox["y==v*x",
    FontWeight->"Bold"],
  " (",
  StyleBox["or by the substitution ",
    FontSize->10,
    FontSlant->"Italic"],
  StyleBox["x==v*y",
    FontSize->10,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", whichever produces an equation which is easier to solve",
    FontSize->10,
    FontSlant->"Italic"],
  ").  Then ",
  StyleBox["dy==dv*x+v*dx",
    FontWeight->"Bold"],
  ", (",
  StyleBox["resp. ",
    FontSize->10,
    FontSlant->"Italic"],
  StyleBox["dx==dv*y+v*dy",
    FontSize->10,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ") and the equation becomes:\n\t\t",
  StyleBox["x^n*p[1,v]*dx + x^n*q[1,v](x*dv+v*dx) == 0,",
    FontWeight->"Bold"],
  "\nwhich simplifies to:\n\t\t",
  StyleBox["(p[1,v]+v*q[1,v])*dx + x*q[1,v]*dv == 0.",
    FontWeight->"Bold"],
  "\nThis equation is separable, so we can apply the techniques for the \
variables separable case to obtain an implicit (sometimes even explicit) \
solution in terms of x and v: ",
  StyleBox["G[x, v] == c",
    FontWeight->"Bold"],
  ". We can then get the solution back in terms of x and y by observing that \
",
  StyleBox["v==y/x",
    FontWeight->"Bold"],
  ", form which we find  ",
  StyleBox["G[x, y/x] ==c",
    FontWeight->"Bold"],
  "  to be a solution."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["An example"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(de[x_, y_] = \((x\^2 + y\^2)\)\ dx + x\ y\ dy == 0\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(dy\ x\ y + dx\ \((x\^2 + y\^2)\) == 0\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Assume ",
  StyleBox["y=v*x",
    FontWeight->"Bold"],
  " and make the substitution:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(de[x, v\ x] /. {dy \[Rule] dv\ x + v\ dx}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(v\ x\^2\ \((dx\ v + dv\ x)\) + dx\ \((x\^2 + v\^2\ x\^2)\) == 
      0\)], "Output"]
}, Closed]],

Cell["\<\
Divide both sides by x^2 (since both functions were homogeneous of \
order 2) and cancel common factors:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[#/x\^2 &, 
      Simplify[de[x, v\ x] /. {dy \[Rule] dv\ x + v\ dx}]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(dx + 2\ dx\ v\^2 + dv\ v\ x == 0\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Collect terms (on each side, hence the use of ",
  StyleBox["Map",
    FontWeight->"Bold"],
  ") to put into standard form:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Collect[#, {dx, dy}] &, %]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(dx\ \((1 + 2\ v\^2)\) + dv\ v\ x == 0\)], "Output"]
}, Closed]],

Cell[TextData[
"This, then, is our separable equation, ready for solving. "], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Problem"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Apply the techniques for solving separable equations (see earlier notebook) \
to obtain a solution to this equation and hence to the original equation. "], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Two problems"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  StyleBox["Problem 1",
    FontVariations->{"Underline"->True}],
  ".  Solve ",
  StyleBox["(2Sqrt[x*y]-y)*dx - x*dy ==0", "Input"],
  ". Test for homogeneity and then solve by making the substitution ",
  StyleBox["y = v*x", "Input"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  StyleBox["Problem 2",
    FontVariations->{"Underline"->True}],
  ".  Solve ",
  StyleBox["(2x^3*y)*dx  + (x^4+y^4)*dy ==0", "Input"],
  ". Test for homogeneity and then solve by making the substitution ",
  StyleBox["x = v*y", "Input"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{521, 621},
WindowMargins->{{70, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 113, 3, 65, "Subtitle",
  Evaluatable->False],
Cell[1892, 58, 703, 16, 122, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2620, 78, 110, 2, 56, "Section",
  Evaluatable->False],
Cell[2733, 82, 860, 27, 122, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[3630, 114, 111, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3766, 120, 90, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3881, 126, 96, 2, 31, "Input"],
Cell[3980, 130, 58, 1, 30, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4075, 136, 46, 1, 27, "Input"],
Cell[4124, 139, 70, 1, 35, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4231, 145, 93, 2, 27, "Input"],
Cell[4327, 149, 65, 1, 32, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4429, 155, 131, 3, 44, "Input"],
Cell[4563, 160, 35, 1, 27, "Output"]
}, Closed]],
Cell[4613, 164, 264, 8, 86, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[4914, 177, 90, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5029, 183, 89, 2, 35, "Input"],
Cell[5121, 187, 51, 1, 35, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5209, 193, 46, 1, 27, "Input"],
Cell[5258, 196, 63, 1, 35, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5358, 202, 56, 1, 27, "Input"],
Cell[5417, 205, 63, 1, 35, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5517, 211, 69, 1, 27, "Input"],
Cell[5589, 214, 63, 1, 35, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5689, 220, 113, 2, 44, "Input"],
Cell[5805, 224, 44, 1, 29, "Output"]
}, Closed]],
Cell[5864, 228, 227, 6, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6116, 238, 158, 4, 44, "Input"],
Cell[6277, 244, 40, 1, 35, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6366, 251, 90, 2, 30, "Subsection",
  Evaluatable->False],
Cell[6459, 255, 182, 4, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6666, 263, 87, 2, 29, "Input"],
Cell[6756, 267, 49, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6842, 273, 99, 2, 31, "Input"],
Cell[6944, 277, 42, 1, 29, "Output"]
}, Closed]],
Cell[7001, 281, 445, 9, 86, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7483, 295, 90, 2, 30, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7598, 301, 87, 2, 42, "Input"],
Cell[7688, 305, 49, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7774, 311, 90, 2, 44, "Input"],
Cell[7867, 315, 35, 1, 27, "Output"]
}, Closed]],
Cell[7917, 319, 131, 3, 32, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8097, 328, 124, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8246, 334, 91, 2, 46, "Subsection",
  Evaluatable->False],
Cell[8340, 338, 413, 13, 86, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8790, 356, 99, 2, 46, "Subsection",
  Evaluatable->False],
Cell[8892, 360, 1607, 51, 212, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[10536, 416, 91, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10652, 422, 110, 2, 31, "Input"],
Cell[10765, 426, 71, 1, 29, "Output"]
}, Closed]],
Cell[10851, 430, 166, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11042, 441, 101, 2, 27, "Input"],
Cell[11146, 445, 104, 2, 29, "Output"]
}, Closed]],
Cell[11265, 450, 177, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11467, 459, 133, 3, 31, "Input"],
Cell[11603, 464, 66, 1, 29, "Output"]
}, Closed]],
Cell[11684, 468, 204, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11913, 479, 90, 2, 27, "Input"],
Cell[12006, 483, 71, 1, 29, "Output"]
}, Closed]],
Cell[12092, 487, 134, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12251, 494, 91, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[12345, 498, 231, 5, 50, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12625, 509, 93, 2, 46, "Subsection",
  Evaluatable->False],
Cell[12721, 513, 319, 10, 50, "Text",
  Evaluatable->False],
Cell[13043, 525, 322, 10, 50, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

